using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class s_AudioManager : MonoBehaviour
{
	//The acutual sounds
	public AudioSource mBackgroundMusic;
	
	public AudioSource mPlayerJump;
	public AudioSource mPlayerJumpBoost;
	public AudioSource mPlayerDie;
	public AudioSource mEnemyDie;
	public AudioSource mChestOpen;
	const uint mSoundCount = 5;
	
	int mSoundItr = 1;				//Itertor for where we are in mSounds
	List<LastSound> mSounds;		//List of all previous sounds
	AudioSource[] mSources;			//This is for fast access to the sound when getting only the index
	bool mRewindDir = true;			//Checks if you changed from rewind to rewind the rewind
	bool mPlayRewindSound = true;	//This makes sure that the first/last sounds in mSources don't loop (was causing problems for me)
	
	class LastSound
	{
		int mTimeStamp;
		byte mSoundIndex;
		
		public void Set(int aTimeStamp, byte aSoundIndex)
		{
			mTimeStamp = aTimeStamp;
			mSoundIndex = aSoundIndex;
		}
		
		public int GetTimeStamp() 	{ return mTimeStamp; }
		public byte GetSoundIndex()	{ return mSoundIndex; } 
	}
	
	void Start()
	{
		//Give listener functions
		s_TimeManager.Get.AddStartFunction(RewindChange);
		s_TimeManager.Get.AddChangeFunction(RewindChange);
		s_TimeManager.Get.AddEndFunction(RewindChange);
		s_TimeManager.Get.AddEndFunction(RewindEnd);
	
		//Create lists/arrays
		mSounds = new List<LastSound>();
		
		mSources = new AudioSource[mSoundCount];
		int i = 0;
		mSources[i++] = mPlayerJump;
		mSources[i++] = mPlayerJumpBoost;
		mSources[i++] = mPlayerDie;
		mSources[i++] = mEnemyDie;
		mSources[i++] = mChestOpen;
	}
	
	void Update()
	{
		if (s_TimeManager.sRewind)
			Rewind();
		
		if (Time.timeScale == 0)
		{
			mBackgroundMusic.pitch = 0;
			SetSoundsPitch(0);
		}
	}
	
	void Rewind()
	{	
		//Checks when to play sounds. Adds the clips length when rewinding since the sound is saved when it is played
		if (mSounds.Count > 0)
		while (s_TimeManager.sRewindSpeed < 0 && (mSounds[mSounds.Count-mSoundItr].GetTimeStamp() +
			(int)(mSources[mSounds[mSounds.Count-mSoundItr].GetSoundIndex()].clip.length / Time.deltaTime) >= s_TimeManager.sTimeStamp)
			|| s_TimeManager.sRewindSpeed > 0 && mSounds[mSounds.Count-mSoundItr].GetTimeStamp() <= s_TimeManager.sTimeStamp)
		{		
			if (Time.timeScale == 0)
				return;
			
			//This makes sure it doesn't loop when at first/last element
			if (mPlayRewindSound)
				PlaySound(mSources[mSounds[mSounds.Count-mSoundItr].GetSoundIndex()]);
			
			//Move the iterator depending on rewind direction
			if (s_TimeManager.sRewindSpeed < 0 && mSoundItr < mSounds.Count)
				++mSoundItr;
			else if (s_TimeManager.sRewindSpeed > 0 && mSoundItr > 1)
				--mSoundItr;
			else
			{
				mPlayRewindSound = false;
				break;
			}
		}
	}
	
	void RewindChange()
	{
		if (Time.timeScale != 0) //Don't want to change it if you are stopped (like at the end of rewind and go from -8 to -4 speed)
		{
			mBackgroundMusic.pitch = s_TimeManager.sRewindSpeed;
			SetSoundsPitch(s_TimeManager.sRewindSpeed);
		}
		else if (s_TimeManager.sTimeStamp == 0)
			mBackgroundMusic.time = 0; //Re-sync time. It would go to end of song soemtimes
		
		//These make sure that the last first/last elements in mSounds don't get looped
		if (mRewindDir && s_TimeManager.sRewindSpeed > 0)
		{
			mRewindDir = false;
			mPlayRewindSound = true;
		}
		else if (!mRewindDir && s_TimeManager.sRewindSpeed < 0)
		{
			mRewindDir = true;
			mPlayRewindSound = true;
		}
	}
	
	void RewindEnd()
	{	
		//Deletes all sounds that have completely been rewinded
		for (int i = 1; i <= mSounds.Count;)
		{
			if (mSounds[mSounds.Count-i].GetTimeStamp() > s_TimeManager.sTimeStamp)
				mSounds.RemoveAt(mSounds.Count-i);
			else
				break; //If this one isn't past the time stamp, none of the ones before it will be either
		}
		
		mSoundItr = 1;
	}
		
		
	
	public void PlaySound(AudioSource aSound)
	{
		//Happens sometimes like when you are in the middle of a sound and change the rewind direction
		if (aSound.isPlaying)
			return;
		
		//Sets where to start the sound depending on if you are rewinding forwards or backwards
		if (s_TimeManager.sRewindSpeed < 0)
			aSound.time = aSound.clip.length;
		else
			aSound.time = 0;
		
		aSound.Play(); //Actually play the sound
		
		//Don't add these sounds if you are rewinding
		if (!s_TimeManager.sRewind)
			AddSound(aSound.priority);
	}
	
	//This will not be rewound. For things that do not rewind usually
	public void PlayNonRewindSound(AudioSource aSound)
	{
		aSound.Play();
	}
	
	void AddSound(int aIndex)
	{
		LastSound temp = new LastSound();
		temp.Set(s_TimeManager.sTimeStamp, (byte)aIndex);
		mSounds.Add(temp);
	}
	
	void SetSoundsPitch(int aPitch)
	{
		mPlayerJump.pitch 		= aPitch;
		mPlayerJumpBoost.pitch  = aPitch;
		mPlayerDie.pitch 		= aPitch;
		mEnemyDie.pitch 		= aPitch;
	}
	
	////////////////////
	// Singleton stuff
	private static s_AudioManager instance;
 
    void Awake() 
    {
        if (instance != null)
            return;
 
        instance = this;
    }
 
    public static s_AudioManager Get
    {
        get
        {
            if (instance == null)
                new s_AudioManager();
 
            return instance;
        }
    }
	////////////////////
}